# 1688 Import Solution - Integration Guide

This package contains the necessary files to setup your scraper service and integrate it with your Laravel (6Valley) application.

## 1. Laravel Application Setup (`laravel_app/`)

Copy the files to your Laravel project preserving the directory structure:

1. **Middleware**: `app/Http/Middleware/ScraperAuthMiddleware.php`
    * Register it in `app/Http/Kernel.php` or `bootstrap/app.php` (if Laravel 11).
    * Alias: `'scraper.auth' => \App\Http\Middleware\ScraperAuthMiddleware::class`.

2. **Controller**: `app/Http/Controllers/Api/ImportProductController.php`

3. **Job**: `app/Jobs/DownloadProductImage.php`

4. **Routes**: Add the content of `routes/api_scraper.php` to your `routes/api.php`.

5. **Environment Variables**: Add the following to your `.env` file:
    * `SCRAPER_TOKEN=your_secure_random_string`
    * `IMPORT_DEFAULT_CATEGORY_ID=5` (Optional: default category for imported products)
    * `IMPORT_DEFAULT_USER_ID=2` (Optional: default user ID for imported products)

## 2. Scraper Service Setup (`scraper_service/`)

Deploy this folder to your separate scraper server/VPS.

1. **Install dependencies**:

    ```bash
    pip install -r requirements.txt
    ```

2. **Configuration**:
    * Edit `main.py` or set environment variables:
        * `LARAVEL_API_URL`: Full URL to your new API endpoint (e.g., `https://your-shop.com/api/scraper/import-product`)
        * `SCRAPER_TOKEN`: Must match the one in your Laravel `.env`.
        * `PROXY_PROVIDER`: Proxy service provider (e.g., 'luminati', 'proxycrawl')
        * `PROXY_API_KEY`: API key for your proxy service
        * `PROXY_USERNAME`: Username for proxy service (if required)
        * `PROXY_PASSWORD`: Password for proxy service (if required)
    * **Proxies**: The scraper now supports professional proxy services for better reliability.

3. **Run**:

    ```bash
    python main.py https://detail.1688.com/offer/123456789.html
    ```

## 3. Automation

Set up a Cron Job (Linux) or Scheduled Task (Windows) on the scraper server to run the script.
Example Cron (every day at 2am):

```bash
0 2 * * * /usr/bin/python3 /path/to/scraper_service/main.py
```

*(Note: You'll likely need a wrapping script to feed it a list of URLs from a database or file).*

## 4. Features

- **Dynamic Proxy Management**: Supports professional proxy services like Luminati and ProxyCrawl
- **Stock Extraction**: Automatically extracts current stock information from 1688 product pages
- **Image Deduplication**: Prevents downloading the same image multiple times
- **Configurable Defaults**: Category and user assignments can be configured via environment variables
- **Improved Error Handling**: Better error handling and logging throughout the process