<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class ScraperAuthMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $scraperToken = config('services.scraper.token');
        $requestToken = $request->header('X-SCRAPER-TOKEN');

        if (!$scraperToken || $requestToken !== $scraperToken) {
            return response()->json([
                'success' => false,
                'message' => 'Unauthorized. Invalid or missing X-SCRAPER-TOKEN.',
            ], 401);
        }

        return $next($request);
    }
}
